<?php

namespace \App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function advertiser()
    {
        return $this->hasOne('\App\Model\Advertiser');
    }

    public function influencer()
    {
        return $this->hasOne('\App\Model\Influencer');
    }

    public function escrowHistory()
    {
        return $this->hasMany('\App\Model\EscrowHistory');
    }

    public function bankAccounts()
    {
        return $this->hasMany('\App\Model\BankAccounts');
    }

}